Attribute VB_Name = "mdCreateCircleAtLineMiddle"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to create a circle with the middle point of a line as its center

Function CreateCircleAtLineMiddle(lineObj As aLine, radius As Double)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim point As aPoint
Set point = GetMidPoint(lineObj)

Dim vector As ZVector
Set vector = point.GetPosition

Set CreateCircleAtLineMiddle = CreateCircle(vector.GetAt(0), vector.GetAt(1), radius)

End Function


Rem Helper function to find the midpoint of a line

Function GetMidPoint(lineObj As aLine)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim point1 As aPoint
Set point1 = lineObj.GetStartPoint

Dim point2 As aPoint
Set point2 = lineObj.GetEndPoint

Dim vector1 As ZVector
Set vector1 = point1.GetPosition

Dim vector2 As ZVector
Set vector2 = point2.GetPosition

X1 = (vector1.GetAt(0) + vector2.GetAt(0)) / 2
Y1 = (vector1.GetAt(1) + vector2.GetAt(1)) / 2
z1 = (vector1.GetAt(2) + vector2.GetAt(2)) / 2

Dim midvector As ZVector
Set midvector = app.GetClass("Vector").CreateVector(X1, Y1, z1)

Set GetMidPoint = app.GetClass("Point").CreatePoint(midvector)

End Function



